/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.util.ObjectUtils;

public abstract class StepContextRepeatCallback
implements RepeatCallback {
    private final Queue<ChunkContext> attributeQueue = new LinkedBlockingQueue<ChunkContext>();
    private final StepExecution stepExecution;
    private final Log logger = LogFactory.getLog(StepContextRepeatCallback.class);

    public StepContextRepeatCallback(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepeatStatus doInIteration(RepeatContext context) throws Exception {
        ChunkContext chunkContext;
        StepContext stepContext = StepSynchronizationManager.register(this.stepExecution);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Preparing chunk execution for StepContext: " + ObjectUtils.identityToString((Object)((Object)stepContext))));
        }
        if ((chunkContext = this.attributeQueue.poll()) == null) {
            chunkContext = new ChunkContext(stepContext);
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Chunk execution starting: queue size=" + this.attributeQueue.size()));
            }
            RepeatStatus repeatStatus = this.doInChunkContext(context, chunkContext);
            return repeatStatus;
        }
        finally {
            if (!chunkContext.isComplete()) {
                this.attributeQueue.add(chunkContext);
            }
            StepSynchronizationManager.close();
        }
    }

    public abstract RepeatStatus doInChunkContext(RepeatContext var1, ChunkContext var2) throws Exception;
}

