/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.builder;

import org.springframework.batch.core.Step;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.core.partition.support.PartitionStep;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.partition.support.SimpleStepExecutionSplitter;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.batch.core.partition.support.TaskExecutorPartitionHandler;
import org.springframework.batch.core.step.builder.StepBuilderException;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class PartitionStepBuilder
extends StepBuilderHelper<PartitionStepBuilder> {
    private TaskExecutor taskExecutor;
    private Partitioner partitioner;
    private static final int DEFAULT_GRID_SIZE = 6;
    private Step step;
    private PartitionHandler partitionHandler;
    private int gridSize = 6;
    private StepExecutionSplitter splitter;
    private StepExecutionAggregator aggregator;
    private String stepName;

    public PartitionStepBuilder(StepBuilderHelper<?> parent) {
        super(parent);
    }

    public PartitionStepBuilder partitioner(String slaveStepName, Partitioner partitioner) {
        this.stepName = slaveStepName;
        this.partitioner = partitioner;
        return this;
    }

    public PartitionStepBuilder step(Step step) {
        this.step = step;
        return this;
    }

    public PartitionStepBuilder taskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
        return this;
    }

    public PartitionStepBuilder partitionHandler(PartitionHandler partitionHandler) {
        this.partitionHandler = partitionHandler;
        return this;
    }

    public PartitionStepBuilder gridSize(int gridSize) {
        this.gridSize = gridSize;
        return this;
    }

    public PartitionStepBuilder splitter(StepExecutionSplitter splitter) {
        this.splitter = splitter;
        return this;
    }

    public PartitionStepBuilder aggregator(StepExecutionAggregator aggregator) {
        this.aggregator = aggregator;
        return this;
    }

    public Step build() {
        PartitionStep step = new PartitionStep();
        step.setName(this.getName());
        super.enhance(step);
        if (this.partitionHandler != null) {
            step.setPartitionHandler(this.partitionHandler);
        } else {
            TaskExecutorPartitionHandler partitionHandler = new TaskExecutorPartitionHandler();
            partitionHandler.setStep(this.step);
            if (this.taskExecutor == null) {
                this.taskExecutor = new SyncTaskExecutor();
            }
            partitionHandler.setGridSize(this.gridSize);
            partitionHandler.setTaskExecutor(this.taskExecutor);
            step.setPartitionHandler(partitionHandler);
        }
        if (this.splitter != null) {
            step.setStepExecutionSplitter(this.splitter);
        } else {
            boolean allowStartIfComplete = this.isAllowStartIfComplete();
            String name = this.stepName;
            if (this.step != null) {
                try {
                    allowStartIfComplete = this.step.isAllowStartIfComplete();
                    name = this.step.getName();
                }
                catch (Exception e) {
                    this.logger.info((Object)("Ignored exception from step asking for name and allowStartIfComplete flag. Using default from enclosing PartitionStep (" + name + "," + allowStartIfComplete + ")."));
                }
            }
            SimpleStepExecutionSplitter splitter = new SimpleStepExecutionSplitter();
            splitter.setPartitioner(this.partitioner);
            splitter.setJobRepository(this.getJobRepository());
            splitter.setAllowStartIfComplete(allowStartIfComplete);
            splitter.setStepName(name);
            this.splitter = splitter;
            step.setStepExecutionSplitter(splitter);
        }
        if (this.aggregator != null) {
            step.setStepExecutionAggregator(this.aggregator);
        }
        try {
            step.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new StepBuilderException(e);
        }
        return step;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    protected Partitioner getPartitioner() {
        return this.partitioner;
    }

    protected Step getStep() {
        return this.step;
    }

    protected PartitionHandler getPartitionHandler() {
        return this.partitionHandler;
    }

    protected int getGridSize() {
        return this.gridSize;
    }

    protected StepExecutionSplitter getSplitter() {
        return this.splitter;
    }

    protected StepExecutionAggregator getAggregator() {
        return this.aggregator;
    }

    protected String getStepName() {
        return this.stepName;
    }
}

