/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class OnPropertyCondition
extends SpringBootCondition {
    OnPropertyCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List<AnnotationAttributes> allAnnotationAttributes = this.annotationAttributesFromMultiValueMap((MultiValueMap<String, Object>)metadata.getAllAnnotationAttributes(ConditionalOnProperty.class.getName()));
        List<ConditionOutcome> noMatchOutcomes = this.findNoMatchOutcomes(allAnnotationAttributes, (PropertyResolver)context.getEnvironment());
        if (noMatchOutcomes.isEmpty()) {
            return ConditionOutcome.match();
        }
        return ConditionOutcome.noMatch(this.getCompositeMessage(noMatchOutcomes));
    }

    private List<AnnotationAttributes> annotationAttributesFromMultiValueMap(MultiValueMap<String, Object> multiValueMap) {
        ArrayList maps = new ArrayList();
        for (Map.Entry entry : multiValueMap.entrySet()) {
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                Map map;
                if (i < maps.size()) {
                    map = (Map)maps.get(i);
                } else {
                    map = new HashMap();
                    maps.add(map);
                }
                map.put(entry.getKey(), ((List)entry.getValue()).get(i));
            }
        }
        ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>(maps.size());
        for (Map map : maps) {
            annotationAttributes.add(AnnotationAttributes.fromMap((Map)map));
        }
        return annotationAttributes;
    }

    private List<ConditionOutcome> findNoMatchOutcomes(List<AnnotationAttributes> allAnnotationAttributes, PropertyResolver resolver) {
        ArrayList<ConditionOutcome> noMatchOutcomes = new ArrayList<ConditionOutcome>(allAnnotationAttributes.size());
        for (AnnotationAttributes annotationAttributes : allAnnotationAttributes) {
            ConditionOutcome outcome = this.determineOutcome(annotationAttributes, resolver);
            if (outcome.isMatch()) continue;
            noMatchOutcomes.add(outcome);
        }
        return noMatchOutcomes;
    }

    private ConditionOutcome determineOutcome(AnnotationAttributes annotationAttributes, PropertyResolver resolver) {
        String prefix = annotationAttributes.getString("prefix").trim();
        if (StringUtils.hasText((String)prefix) && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String havingValue = annotationAttributes.getString("havingValue");
        String[] names = this.getNames((Map<String, Object>)annotationAttributes);
        boolean relaxedNames = annotationAttributes.getBoolean("relaxedNames");
        boolean matchIfMissing = annotationAttributes.getBoolean("matchIfMissing");
        if (relaxedNames) {
            resolver = new RelaxedPropertyResolver(resolver, prefix);
        }
        ArrayList<String> missingProperties = new ArrayList<String>();
        ArrayList<String> nonMatchingProperties = new ArrayList<String>();
        for (String name : names) {
            String key;
            String string = key = relaxedNames ? name : prefix + name;
            if (resolver.containsProperty(key)) {
                if (this.isMatch(resolver.getProperty(key), havingValue)) continue;
                nonMatchingProperties.add(name);
                continue;
            }
            if (matchIfMissing) continue;
            missingProperties.add(name);
        }
        if (missingProperties.isEmpty() && nonMatchingProperties.isEmpty()) {
            return ConditionOutcome.match();
        }
        StringBuilder message = new StringBuilder("@ConditionalOnProperty ");
        if (!missingProperties.isEmpty()) {
            message.append("missing required properties ").append(this.expandNames(prefix, missingProperties)).append(" ");
        }
        if (!nonMatchingProperties.isEmpty()) {
            String expected = StringUtils.hasLength((String)havingValue) ? havingValue : "!false";
            message.append("expected '").append(expected).append("' for properties ").append(this.expandNames(prefix, nonMatchingProperties));
        }
        return ConditionOutcome.noMatch(message.toString());
    }

    private String[] getNames(Map<String, Object> annotationAttributes) {
        String[] value = (String[])annotationAttributes.get("value");
        String[] name = (String[])annotationAttributes.get("name");
        Assert.state((value.length > 0 || name.length > 0 ? 1 : 0) != 0, (String)"The name or value attribute of @ConditionalOnProperty must be specified");
        Assert.state((value.length == 0 || name.length == 0 ? 1 : 0) != 0, (String)"The name and value attributes of @ConditionalOnProperty are exclusive");
        return value.length > 0 ? value : name;
    }

    private boolean isMatch(String value, String requiredValue) {
        if (StringUtils.hasLength((String)requiredValue)) {
            return requiredValue.equalsIgnoreCase(value);
        }
        return !"false".equalsIgnoreCase(value);
    }

    private String expandNames(String prefix, List<String> names) {
        StringBuilder expanded = new StringBuilder();
        for (String name : names) {
            expanded.append(expanded.length() == 0 ? "" : ", ");
            expanded.append(prefix);
            expanded.append(name);
        }
        return expanded.toString();
    }

    private String getCompositeMessage(List<ConditionOutcome> noMatchOutcomes) {
        StringBuilder message = new StringBuilder();
        for (ConditionOutcome noMatchOutcome : noMatchOutcomes) {
            if (message.length() > 0) {
                message.append(". ");
            }
            message.append(noMatchOutcome.getMessage().trim());
        }
        return message.toString();
    }
}

