/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.step;

import java.util.Collection;
import javax.batch.api.partition.PartitionReducer;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.jsr.partition.JsrPartitionHandler;
import org.springframework.batch.core.jsr.partition.support.JsrStepExecutionAggregator;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.StepLocator;

public class PartitionStep
extends org.springframework.batch.core.partition.support.PartitionStep
implements StepLocator {
    private PartitionReducer reducer;
    private boolean hasReducer = false;
    private StepExecutionAggregator stepExecutionAggregator = new JsrStepExecutionAggregator();

    public void setPartitionReducer(PartitionReducer reducer) {
        this.reducer = reducer;
        this.hasReducer = reducer != null;
    }

    @Override
    protected void doExecute(StepExecution stepExecution) throws Exception {
        if (this.hasReducer) {
            this.reducer.beginPartitionedStep();
        }
        Collection<StepExecution> stepExecutions = this.getPartitionHandler().handle(null, stepExecution);
        stepExecution.upgradeStatus(BatchStatus.COMPLETED);
        this.stepExecutionAggregator.aggregate(stepExecution, stepExecutions);
        if (stepExecution.getStatus().isUnsuccessful()) {
            if (this.hasReducer) {
                this.reducer.rollbackPartitionedStep();
                this.reducer.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.ROLLBACK);
            }
            throw new JobExecutionException("Partition handler returned an unsuccessful step");
        }
        if (this.hasReducer) {
            this.reducer.beforePartitionedStepCompletion();
            this.reducer.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.COMMIT);
        }
    }

    @Override
    public Collection<String> getStepNames() {
        return ((JsrPartitionHandler)this.getPartitionHandler()).getPartitionStepNames();
    }

    @Override
    public Step getStep(String stepName) throws NoSuchStepException {
        JsrPartitionHandler partitionHandler = (JsrPartitionHandler)this.getPartitionHandler();
        Collection<String> names = partitionHandler.getPartitionStepNames();
        if (names.contains(stepName)) {
            return partitionHandler.getStep();
        }
        throw new NoSuchStepException(stepName + " was not found");
    }
}

