/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spockframework.util.IMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter<T> {
    private final IMatcher<T> matcher;

    private Filter(IMatcher<T> matcher) {
        this.matcher = matcher;
    }

    public List<T> filter(List<? extends T> items) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : items) {
            if (!this.matcher.matches(item)) continue;
            result.add(item);
        }
        return result;
    }

    public void filterInPlace(List<? extends T> items) {
        Iterator<T> iter = items.iterator();
        while (iter.hasNext()) {
            if (this.matcher.matches(iter.next())) continue;
            iter.remove();
        }
    }

    public static <T> Filter<T> create(IMatcher<T> matcher) {
        return new Filter<T>(matcher);
    }
}

