/*
 * Copyright 2008-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.glassfish.auth.cache.impl;


/**
 * MBean implmenetation for {@link SimpleExpiryCache}.
 * 
 * @author Erik Brakkee
 *
 */
class SimpleExpiryCacheManagement implements
    SimpleExpiryCacheManagementMBean {
    
    private SimpleExpiryCache cache; 
    
    public SimpleExpiryCacheManagement(SimpleExpiryCache aCache) { 
        cache = aCache; 
    }
    
    @Override
    public int size() {
        return cache.size();
    }
    
    @Override
    public int getExpiryTimeSeconds() {
        return cache.getExpiryTimeSeconds();
    }

    @Override
    public String[] users() {
        return cache.getEntries().keySet().toArray(
            new String[0]);
    }

    @Override
    public void clearUser(String aUsername) {
        cache.getEntries().remove(aUsername);
    }

    @Override
    public void clearExpired() {
        cache.clearExpired();
    }

    @Override
    public void clearAll() {
        cache.getEntries().clear();
    }
}