/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.glassfish.auth.cache.impl;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.wamblee.glassfish.auth.cache.api.AuthenticationCache;
import org.wamblee.glassfish.auth.cache.impl.SimpleExpiryCacheManagement;
import org.wamblee.glassfish.auth.cache.impl.SimpleExpiryCacheManagementMBean;

public class SimpleExpiryCache
implements AuthenticationCache {
    private static final String JMX_REALM_PROPERTY = "realm";
    private static final Logger LOGGER = Logger.getLogger(SimpleExpiryCache.class.getName());
    public static final String PROP_EXPIRY_TIME_SECONDS = "cache.timeoutSeconds";
    public static final String JMX_DOMAIN = "org.wamblee.glassfish.auth.FlexibleJdbcRealm";
    public static final String PROP_REALM_NAME = "jaas.context";
    public static final long DEFAULT_EXPIRY_TIME_SECONDS = 60L;
    private Map<String, UserEntry> entries;
    private Clock clock = new SystemClock();
    private long expiryTimeMillis = 60000L;

    public SimpleExpiryCache(Properties aProperties) {
        this.entries = new ConcurrentHashMap<String, UserEntry>();
        String timeoutString = aProperties.getProperty(PROP_EXPIRY_TIME_SECONDS);
        if (timeoutString != null) {
            try {
                this.expiryTimeMillis = (long)Integer.parseInt(timeoutString) * 1000L;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Error parsing timeout value from property cache.timeoutSeconds with value '" + timeoutString, e);
            }
        }
        LOGGER.info("Cache expiry time is " + this.expiryTimeMillis / 1000L + " seconds");
        String realm = aProperties.getProperty(PROP_REALM_NAME);
        SimpleExpiryCacheManagement mbean = new SimpleExpiryCacheManagement(this);
        this.register(mbean, realm);
    }

    Map<String, UserEntry> getEntries() {
        return this.entries;
    }

    private void register(SimpleExpiryCacheManagementMBean aMbean, String aRealm) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName(JMX_DOMAIN, JMX_REALM_PROPERTY, aRealm);
            try {
                server.unregisterMBean(name);
            }
            catch (JMException e) {
                // empty catch block
            }
            server.registerMBean(aMbean, name);
            LOGGER.info("Registered MBean at '" + name + "'");
        }
        catch (JMException e) {
            LOGGER.log(Level.WARNING, "Could not register MBean for SimpleExpiryCache for realm '" + aRealm + "'", e);
        }
    }

    protected void clearExpired() {
        HashSet<String> users = new HashSet<String>(this.entries.keySet());
        for (String user : users) {
            this.getUserEntry(user);
        }
    }

    public SimpleExpiryCache(Properties aProperties, Clock aClock) {
        this(aProperties);
        this.clock = aClock;
    }

    public int getExpiryTimeSeconds() {
        return (int)(this.expiryTimeMillis / 1000L);
    }

    public int size() {
        return this.entries.size();
    }

    public String toString() {
        return this.getClass().getName() + "(expiryTimeMillis = " + this.expiryTimeMillis + " seconds)";
    }

    @Override
    public List<String> getGroups(String aUsername) {
        UserEntry entry = this.getUserEntry(aUsername);
        return entry == null ? null : entry.getGroups();
    }

    @Override
    public String getPassword(String aUsername) {
        UserEntry entry = this.getUserEntry(aUsername);
        return entry == null ? null : entry.getPassword();
    }

    @Override
    public String getSeed(String aUsername) {
        UserEntry entry = this.getUserEntry(aUsername);
        return entry == null ? null : entry.getSeed();
    }

    @Override
    public void setGroups(String aUsername, List<String> aGroups) {
        this.ensureUserEntry(aUsername).setGroups(aGroups);
    }

    @Override
    public void setPassword(String aUserName, String aPassword) {
        this.ensureUserEntry(aUserName).setPassword(aPassword);
    }

    @Override
    public void setSeed(String aUsername, String aSeed) {
        this.ensureUserEntry(aUsername).setSeed(aSeed);
    }

    private UserEntry getUserEntry(String aUser) {
        UserEntry user = this.entries.get(aUser);
        if (user == null) {
            this.entries.remove(aUser);
            return null;
        }
        long t = this.clock.currentTimeMillis();
        if (user.getExpiryTime() < t) {
            this.entries.remove(aUser);
            return null;
        }
        return user;
    }

    private UserEntry ensureUserEntry(String aUser) {
        UserEntry entry = this.getUserEntry(aUser);
        if (entry == null) {
            long expiry = this.expiryTimeMillis < 0L ? Long.MAX_VALUE : this.clock.currentTimeMillis() + this.expiryTimeMillis;
            entry = new UserEntry(expiry);
            this.entries.put(aUser, entry);
        }
        return entry;
    }

    public static class SystemClock
    implements Clock {
        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }

    public static interface Clock {
        public long currentTimeMillis();
    }

    public static class UserEntry {
        private long expiryTime;
        private String password;
        private List<String> groups;
        private String seed;

        public UserEntry(long aExpiryTime) {
            this.expiryTime = aExpiryTime;
        }

        public synchronized List<String> getGroups() {
            return this.groups;
        }

        public synchronized String getPassword() {
            return this.password;
        }

        public synchronized String getSeed() {
            return this.seed;
        }

        public synchronized void setGroups(List<String> aGroups) {
            this.groups = aGroups;
        }

        public synchronized void setPassword(String aPassword) {
            this.password = aPassword;
        }

        public synchronized void setSeed(String aSeed) {
            this.seed = aSeed;
        }

        public long getExpiryTime() {
            return this.expiryTime;
        }
    }
}

