/*
 * Copyright 2008-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.glassfish.auth.cache.impl;

import java.util.List;
import java.util.Properties;

import org.wamblee.glassfish.auth.cache.api.AuthenticationCache;

/**
 * Authentication cache which does not cache.
 * 
 * @author Erik Brakkee
 *
 */
public class NoAuthenticationCache implements AuthenticationCache {
    
    public NoAuthenticationCache(Properties aProperties) { 
        // Empty. 
    }

    @Override
    public String getPassword(String aUsername) {
        return null;
    }
    
    @Override
    public void setPassword(String aUserName, String aPassword) {
        // Empty   
    }

    @Override
    public List<String> getGroups(String aUsername) {
        return null;
    }
    
    @Override
    public void setGroups(String aUsername, List<String> aGroups) {
        // Empty   
    }

    @Override
    public String getSeed(String aUsername) {
        return null;
    }
    
    @Override
    public void setSeed(String aUsername, String aSeed) {
        // Empty.   
    }
    
    @Override
    public String toString() {
        return getClass().getName();
    }
}
