/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.glassfish.auth.cache.impl;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.JMException;
import javax.management.ObjectName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.glassfish.auth.cache.impl.SimpleExpiryCache;

public class SimpleExpiryCacheTest {
    private static final String REALM_NAME = "myrealm";
    private static final long INITIAL_TIME = 10000000L;
    private static final String USER1 = "user1";
    private static final String USER2 = "user2";
    private SimpleExpiryCache.Clock clock;
    private Properties props;

    @Before
    public void setUp() {
        this.clock = (SimpleExpiryCache.Clock)Mockito.mock(SimpleExpiryCache.Clock.class);
        this.props = new Properties();
        this.props.put("jaas.context", REALM_NAME);
        Mockito.when((Object)this.clock.currentTimeMillis()).thenReturn((Object)10000000L);
    }

    private void setExpiry(String aExpiryMillis) {
        this.props.put("cache.timeoutSeconds", aExpiryMillis);
    }

    @Test
    public void testDefaultExpiry() {
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props);
        Assert.assertEquals((long)60L, (long)cache.getExpiryTimeSeconds());
    }

    @Test
    public void testConfiguredExpiry() {
        this.setExpiry("35");
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props);
        Assert.assertEquals((int)35, (int)cache.getExpiryTimeSeconds());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testErrorParsingExpiry() {
        this.setExpiry("abd10");
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props);
    }

    @Test
    public void testCachePassword() {
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props, this.clock);
        String passwd = cache.getPassword(USER1);
        Assert.assertNull((Object)passwd);
        cache.setPassword(USER1, "jantje");
        this.setCacheAlmostExpires();
        Assert.assertEquals((String)"jantje", (String)cache.getPassword(USER1));
        Assert.assertEquals((int)1, (int)cache.size());
        this.setCacheToExpire();
        Assert.assertNull((Object)cache.getPassword(USER1));
        Assert.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testNeverExpires() {
        this.setExpiry("-1");
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props);
        Assert.assertTrue((cache.getExpiryTimeSeconds() < 0 ? 1 : 0) != 0);
        cache.setPassword(USER1, "passwd");
        Assert.assertEquals((int)1, (int)cache.size());
        Mockito.when((Object)this.clock.currentTimeMillis()).thenReturn((Object)1000000000L);
        cache.clearExpired();
        Assert.assertEquals((int)1, (int)cache.size());
    }

    private void setCacheAlmostExpires() {
        Mockito.when((Object)this.clock.currentTimeMillis()).thenReturn((Object)10059999L);
    }

    private void setCacheToExpire() {
        Mockito.when((Object)this.clock.currentTimeMillis()).thenReturn((Object)10060001L);
    }

    @Test
    public void testCacheSeed() {
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props, this.clock);
        String seed = cache.getSeed(USER1);
        Assert.assertNull((Object)seed);
        cache.setSeed(USER1, "jantje");
        this.setCacheAlmostExpires();
        Assert.assertEquals((String)"jantje", (String)cache.getSeed(USER1));
        Assert.assertEquals((int)1, (int)cache.size());
        this.setCacheToExpire();
        Assert.assertNull((Object)cache.getSeed(USER1));
        Assert.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testCacheGroups() {
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props, this.clock);
        List seed = cache.getGroups(USER1);
        Assert.assertNull((Object)seed);
        cache.setGroups(USER1, Arrays.asList("g1", "g2"));
        this.setCacheAlmostExpires();
        Assert.assertEquals(Arrays.asList("g1", "g2"), (Object)cache.getGroups(USER1));
        Assert.assertEquals((int)1, (int)cache.size());
        this.setCacheToExpire();
        Assert.assertNull((Object)cache.getGroups(USER1));
        Assert.assertEquals((int)0, (int)cache.size());
    }

    private ObjectName getObjectName() throws JMException {
        return new ObjectName("org.wamblee.glassfish.auth.FlexibleJdbcRealm", "realm", REALM_NAME);
    }

    @Test
    public void testInvokeMBeanSizeUsers() throws Exception {
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props, this.clock);
        cache.setGroups(USER1, Arrays.asList("g1", "g2"));
        int size = (Integer)ManagementFactory.getPlatformMBeanServer().invoke(this.getObjectName(), "size", new Object[0], new String[0]);
        Assert.assertEquals((int)1, (int)size);
        String[] users = (String[])ManagementFactory.getPlatformMBeanServer().invoke(this.getObjectName(), "users", new Object[0], new String[0]);
        Assert.assertEquals((int)1, (int)users.length);
        Assert.assertEquals((String)USER1, (String)users[0]);
    }

    @Test
    public void testInvokeMBeanExpireUser() throws Exception {
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props, this.clock);
        cache.setGroups(USER1, Arrays.asList("g1", "g2"));
        int size = (Integer)ManagementFactory.getPlatformMBeanServer().invoke(this.getObjectName(), "size", new Object[0], new String[0]);
        Assert.assertEquals((int)1, (int)size);
        ManagementFactory.getPlatformMBeanServer().invoke(this.getObjectName(), "clearUser", new Object[]{"user1x"}, new String[]{String.class.getName()});
        Assert.assertEquals((int)1, (int)cache.size());
        ManagementFactory.getPlatformMBeanServer().invoke(this.getObjectName(), "clearUser", new Object[]{USER1}, new String[]{String.class.getName()});
        Assert.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testInvokeMbeanClearAll() throws Exception {
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props, this.clock);
        cache.setGroups(USER1, Arrays.asList("g1", "g2"));
        cache.setPassword(USER2, "dkdkd");
        Assert.assertEquals((int)2, (int)cache.size());
        ManagementFactory.getPlatformMBeanServer().invoke(this.getObjectName(), "clearAll", new Object[0], new String[0]);
        Assert.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testInvokeMbeanClearExpired() throws Exception {
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props, this.clock);
        cache.setGroups(USER1, Arrays.asList("g1", "g2"));
        Mockito.when((Object)this.clock.currentTimeMillis()).thenReturn((Object)10000030L);
        cache.setPassword(USER2, "dkdkdk");
        Assert.assertEquals((int)2, (int)cache.size());
        this.setCacheToExpire();
        Assert.assertEquals((int)2, (int)cache.size());
        ManagementFactory.getPlatformMBeanServer().invoke(this.getObjectName(), "clearExpired", new Object[0], new String[0]);
        Assert.assertEquals((int)1, (int)cache.size());
    }

    @Test
    public void testPerformanceOfEvictUser() throws Exception {
        SimpleExpiryCache cache = new SimpleExpiryCache(this.props, this.clock);
        int n = 10000;
        long tbegin = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            ManagementFactory.getPlatformMBeanServer().invoke(this.getObjectName(), "clearUser", new Object[]{"user1x"}, new String[]{String.class.getName()});
        }
        long tend = System.currentTimeMillis();
        System.out.println(n + " user evictions in " + (tend - tbegin) + "ms");
        System.out.println((long)n / (tend - tbegin) * 1000L + " evictions/s");
    }
}

