/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.safe.model.jpa;

import javax.enterprise.inject.Produces;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.wamblee.general.LookupProxyFactory;
import org.wamblee.general.LookupProxyFactory.Lookup;
import org.wamblee.inject.InjectorBuilder;

public class EntityManagerLookup implements Lookup {

    private static class EmHolder {
        @PersistenceContext
        private EntityManager em;

        public EntityManager getEm() {
            return em;
        }
    }

    private transient EntityManager em;

    @Override
    public Object lookup() throws Exception {
        if (em == null) {
            EmHolder holder = new EmHolder();
            InjectorBuilder.getInjector().inject(holder);
            em = holder.getEm();
        }
        return em;
    }

    @Produces
    @ApplicationDatabase
    @PersistenceContext
    public EntityManager getDefaultEntityManager() {
        LookupProxyFactory<EntityManager> factory = new LookupProxyFactory<EntityManager>(
            EntityManager.class, new EntityManagerLookup());
        return factory.getProxy();
    }

}
