/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.safe.wicket;

import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.wamblee.safe.model.Entry;
import org.wamblee.wicket.behavior.ServerTooltipBehavior;
import org.wamblee.wicket.behavior.TitleAttributeTooltipBehavior;

public abstract class EditEntryForm extends Form {
    
    private static final String[] FIELDS = { "username", "password", "description" }; 
    
    public EditEntryForm(String aId, IModel<Entry> aEntry) { 
        super(aId);
        setDefaultModel(aEntry);
        
        add(new RequiredTextField<String>("name", new PropertyModel(aEntry, "name")));
        add(textField("username", new FieldModel(aEntry, "username")));
        add(textField("password", new FieldModel(aEntry, "password")));
        add(new TextArea("description", new FieldModel(aEntry, "description")).setConvertEmptyInputStringToNull(false));
        
        Button close = new Button("close") {
            @Override
            public void onSubmit() {
                EditEntryForm.this.closePressed();
            }
        };
        close.setDefaultFormProcessing(false);
        add(close);
    }
    
    private FormComponent textField(String aId, IModel aModel) { 
        FormComponent field = new TextField(aId, aModel).setConvertEmptyInputStringToNull(false);
        return field; 
    }
    
    @Override
    protected void onSubmit() {
        super.onSubmit();
        entryEdited((Entry)getDefaultModel().getObject()); 
    }
    
    protected abstract void entryEdited(Entry aEntry); 
    
    protected abstract void closePressed();

}
