/*
 * Copyright 2005-2011 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.safe.wicket;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.wamblee.safe.model.Entry;

/**
 * Panel representing a link to an item. 
 * @author Erik Brakkee
 *
 */
public class EntryLinkPanel extends Panel {
   
    
    public EntryLinkPanel(String aId, final Entry aEntry, String aHeader) { 
        super(aId);
        String name = aEntry.getName();
        Label header;
        if ( aHeader != null ) { 
            header = new Label("header", aHeader);
        }
        else { 
            header = new Label("header", "");
        }
        add(header);
        Link link = new Link("link") {
            @Override
            public void onClick() {
                setResponsePage(new ViewEntryPage(getWebPage(), aEntry)); 
            }
        };
        link.add(new Label("name", name));     
        add(link);
    }

}
