/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.safe.wicket;

import javax.inject.Inject;

import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.wamblee.safe.model.Entry;

public abstract class ViewEntryPanel extends Panel {
    
    @Inject
    private DetachableEntityFactory factory; 
    
    public ViewEntryPanel(String aId, final IModel<Entry> aEntry) { 
        super(aId);
       
        add(new ViewEntryForm("entry", aEntry) {
            
            @Override
            protected void deletePressed(Entry aEditedEntry) {
                ViewEntryPanel.this.deletePressed(aEditedEntry);
            }
            
            @Override
            protected void editPressed(Entry aEditedEntry) {
                ViewEntryPanel.this.editPressed(aEditedEntry);
            }

            @Override
            protected void backPressed() {
                ViewEntryPanel.this.backPressed();   
            }
        });
    }
       
    protected abstract void editPressed(Entry aEntry);
    
    protected abstract void deletePressed(Entry aEntry);

    protected abstract void backPressed();
    
}
