/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.safe.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.wamblee.safe.model.Field;

@Entity
@Table(name="SAFE_ENTRY")
public class Entry
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(nullable=false)
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=Field.class, fetch=FetchType.EAGER)
    @JoinTable(name="SAFE_ENTRY_FIELD", joinColumns={@JoinColumn(name="ENTRY_ID")}, inverseJoinColumns={@JoinColumn(name="FIELD_ID")})
    @OrderColumn(name="FIELD_INDEX")
    private List<Field> fields;

    public Entry() {
        this.fields = new ArrayList();
    }

    public Entry(String aName) {
        this(aName, new ArrayList());
    }

    public Entry(String aName, List<Field> aFields) {
        this.name = aName;
        this.fields = aFields;
    }

    public void set(Entry aEntry) {
        this.name = aEntry.name;
        ArrayList<Field> removed = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (aEntry.find(field.getName()) != null) continue;
            removed.add(field);
        }
        for (Field remove : removed) {
            this.fields.remove(remove);
        }
        for (Field field : aEntry.getFields()) {
            this.setField(field.getName(), field.getValue());
        }
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getField(String aName) {
        return this.findAndCreate(aName).getValue();
    }

    public void setField(String aName, String aValue) {
        this.findAndCreate(aName).setValue(aValue);
    }

    private Field findAndCreate(String aName) {
        Field field = this.find(aName);
        if (field == null) {
            field = new Field(aName, "");
            this.fields.add(field);
        }
        return field;
    }

    private Field find(String aName) {
        for (Field field : this.fields) {
            if (!field.getName().equals(aName)) continue;
            return field;
        }
        return null;
    }

    public boolean equals(Object aObj) {
        if (aObj == null) {
            return false;
        }
        if (!(aObj instanceof Entry)) {
            return false;
        }
        Entry entry = (Entry)aObj;
        return this.name.equals(entry.name) && this.id == entry.id;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Entry(id = " + this.id + ", name = " + this.name + ")";
    }
}

