/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.safe.model.jpa;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.wamblee.inject.Injectable;
import org.wamblee.persistence.Detachable;
import org.wamblee.persistence.JpaDetachable;
import org.wamblee.safe.model.Account;
import org.wamblee.safe.model.Entry;
import org.wamblee.safe.model.Storage;

@ApplicationScoped
public class JpaStorage
extends Injectable
implements Storage,
Serializable {
    private static final String DEFAULT_ACCOUNT = "default";
    private static final String ACCOUNT_NAME_PARAM = "name";
    private static final String FIND_ACCOUNT_QUERY = "select a from Account a where a.name = :name";
    private static final String FIND_ENTRIES_QUERY = "select e from Entry e order by e.name";
    private static final String COUNT_ENTRIES_QUERY = "select count(e) from Entry e";
    @PersistenceContext
    private EntityManager em;

    public <T> Detachable<T> createDetachable(T aObject) {
        return new JpaDetachable(this.em, aObject);
    }

    public void flush() {
        this.em.flush();
    }

    public Detachable<Account> getDefaultAccount() {
        TypedQuery query = this.em.createQuery(FIND_ACCOUNT_QUERY, Account.class).setParameter(ACCOUNT_NAME_PARAM, (Object)DEFAULT_ACCOUNT);
        Account account = null;
        try {
            account = (Account)query.getSingleResult();
        }
        catch (NoResultException e) {
            account = new Account(DEFAULT_ACCOUNT);
            this.em.persist((Object)account);
        }
        return this.createDetachable((Object)account);
    }

    public List<Entry> findEntries(int aStart, int aCount) {
        TypedQuery query = this.em.createQuery(FIND_ENTRIES_QUERY, Entry.class);
        query.setFirstResult(aStart);
        query.setMaxResults(aCount);
        return query.getResultList();
    }

    public int countEntries() {
        TypedQuery query = this.em.createQuery(COUNT_ENTRIES_QUERY, Long.class);
        return ((Long)query.getSingleResult()).intValue();
    }
}

