/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.safe.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class AuthenticationFilter
implements Filter {
    private static final String LOGINPAGE = "loginpage";
    private static final String REQUIRED_ROLE = "role";
    private static final String RESOURCES = "resources";
    private String loginPage;
    private String role;
    private String resources;

    public void init(FilterConfig aFilterConfig) throws ServletException {
        this.loginPage = aFilterConfig.getInitParameter(LOGINPAGE);
        if (this.loginPage == null) {
            throw new ServletException("No login page defined! Must specify 'loginpage' filter init parameter.");
        }
        this.role = aFilterConfig.getInitParameter(REQUIRED_ROLE);
        if (this.role == null) {
            throw new ServletException("No role name defined! Must specify 'role' filter init parameter.");
        }
        this.resources = aFilterConfig.getInitParameter(RESOURCES);
    }

    public void doFilter(ServletRequest aRequest, ServletResponse aResponse, FilterChain aChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)aRequest;
        String fullPath = request.getRequestURI();
        String contextPath = request.getContextPath();
        String relpath = null;
        if (fullPath.startsWith(contextPath)) {
            relpath = fullPath.substring(contextPath.length());
        }
        if (request.isUserInRole(this.role) || this.resources != null && relpath != null && relpath.startsWith(this.resources)) {
            aChain.doFilter(aRequest, aResponse);
        } else {
            request.getSession().invalidate();
            request.getRequestDispatcher(this.loginPage).forward(aRequest, aResponse);
        }
    }

    public void destroy() {
    }
}

