/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.safe.wicket;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.wamblee.safe.model.Storage;
import org.wamblee.wicket.behavior.TitleAttributeTooltipBehavior;
import org.wamblee.wicket.css.ResetCssBehavior;
import org.wamblee.wicket.page.PageBehavior;
import org.wamblee.wicket.page.WebApplicationBasePage;

public class BasePage
extends WebApplicationBasePage {
    @Inject
    private Storage storage;
    @PersistenceContext
    private EntityManager entityManager;
    private boolean isExpired = false;

    public BasePage() {
        this(null);
    }

    public BasePage(IModel aModel) {
        super(aModel);
        this.add(new IBehavior[]{new ResetCssBehavior()});
        this.add(new IBehavior[]{new TitleAttributeTooltipBehavior()});
        this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution(BasePage.class, (String)"safe.css")});
        this.addBehavior((PageBehavior)new /* Unavailable Anonymous Inner Class!! */);
        this.disableCaching();
        this.add(new Component[]{new FeedbackPanel("feedback")});
        this.add(new Component[]{new Label("title", this.getTitle())});
        this.addBehavior((PageBehavior)new /* Unavailable Anonymous Inner Class!! */);
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    public void setExpired(boolean aExpired) {
        this.isExpired = aExpired;
    }

    private String getTitle() {
        String name = this.getClass().getSimpleName();
        name = name.replaceAll("([A-Z]+)([A-Z][a-z])", "$1 $2");
        name = name.replaceAll("[A-Z]+", " $0");
        name = name.replaceAll("^ ", "");
        name = name.replaceAll("  ", " ");
        return name;
    }

    static /* synthetic */ EntityManager access$000(BasePage x0) {
        return x0.entityManager;
    }

    static /* synthetic */ boolean access$100(BasePage x0) {
        return x0.isExpired;
    }
}

