/*
 * Copyright 2005-2011 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.safe.security;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import org.wamblee.safe.model.FieldEncryptor;

/**
 * Created with IntelliJ IDEA.                                     lden
 * User: erik
 * Date: 1/2/18
 * Time: 2:04 PM
 * To change this template use File | Settings | File Templates.
 */
public class SafeFieldEncryptor implements FieldEncryptor, Serializable {

    private static final byte[] IV = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private byte[] password;
    private int maxLength;

    public SafeFieldEncryptor(String aPassword, int aMaxLength) {
        // AES requires 16, 24, or 32 byte key.
        password = new byte[16];
        int i = 0;
        for (byte b : aPassword.getBytes()) {
            if (i < 32) {
                password[i++] = b;
            }
        }
        for (int j = i; j < password.length; j++) {
            password[j] = (byte) (password[j - i] - 5);
        }
        maxLength = aMaxLength;
    }

    @Override
    public String encrypt(String aValue) {
        String res;
        try {
            Cipher cipher = getCipher();
            SecretKeySpec skeyspec = new SecretKeySpec(password, "AES");

            cipher.init(Cipher.ENCRYPT_MODE, skeyspec, new IvParameterSpec(IV));
            byte[] encrypted = cipher.doFinal(aValue.getBytes());

            res = Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (res.length() > maxLength) {
            throw new ValueTooLargeException(aValue);
        }
        return res;
    }

    private Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("AES/CBC/PKCS5Padding");
    }

    @Override
    public String decrypt(String aValue) {
        if (aValue == null || aValue.length() == 0) {
            return "";
        }
        String res;
        try {
            byte[] valueBytes = Base64.getDecoder().decode(aValue);
            Cipher cipher = getCipher();
            SecretKeySpec skeyspec = new SecretKeySpec(password, "AES");

            cipher.init(Cipher.DECRYPT_MODE, skeyspec, new IvParameterSpec(IV));
            byte[] decrypted = cipher.doFinal(valueBytes);

            res = new String(decrypted);
        }
        catch (Exception e) {
            return CANNOT_DECRYPT_VALUE;
        }
        return res;
    }
}
