/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.safe.wicket;

import java.util.ArrayList;

import javax.inject.Inject;

import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;
import org.wamblee.safe.model.Entry;
import org.wamblee.safe.model.Field;
import org.wamblee.safe.model.Storage;
import org.wamblee.wicket.behavior.PreselectionBehavior;

/**
 * Homepage
 */
public class AddEntryPage extends BasePage {

    private static final long serialVersionUID = 1L;

    @Inject
    private Storage storage;

    /**
     * Constructor that is invoked when page is invoked without a session.
     */
    public AddEntryPage() {
        super();
        final Entry entry = new Entry("New", new ArrayList<Field>());
        Panel panel = new EditEntryPanel("entryform", new Model<Entry>(entry)) {

            @Override
            protected void entryEdited(Entry aEntry) {
                storage.getDefaultAccount().get().getEntries().add(aEntry);
                storage.flush();
                getSession().info("Entry was saved");
                setResponsePage(HomePage.class);
            }

            @Override
            protected void closePressed() {
                getSession().info("Entry not added");
                setResponsePage(HomePage.class);
            }
        };
        add(new PreselectionBehavior());
        add(panel);
    }
}
