/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.safe.wicket;

import javax.inject.Inject;

import org.wamblee.safe.model.Entry;

/**
 * Homepage
 */
public class EditEntryPage extends BasePage {

    private static final long serialVersionUID = 1L;

    @Inject
    private DetachableEntityFactory factory;

    /**
     * Constructor that is invoked when page is invoked without a session.
     *
     * @param aEntry Entry to edit.
     */
    public EditEntryPage(final Entry aEntry) {
        super();

        add(new EditEntryPanel("entryform", factory.detachable(aEntry)) {
            @Override
            protected void entryEdited(Entry aEditedEntry) {
                getSession().info("Entry was saved");
                setResponsePage(HomePage.class);
            }

            @Override
            protected void closePressed() {
                getSession().info("Entry unchanged");
                setResponsePage(HomePage.class);
            }
        });
    }
}
