/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.safe.wicket;

import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class EnterEncryptionPasswordPanel extends Panel {

    public EnterEncryptionPasswordPanel(String aId) {
        super(aId);

        Form form = new Form("enterEncryptionPassword") {
            @Override
            protected void onSubmit() {
                super.onSubmit();
            }
        };
        add(form);

        PasswordTextField passwordField = new PasswordTextField("password", new IModel<String>() {
            @Override
            public String getObject() {
                return EncryptionPasswordAccess.getEncryptionPassword(getSession());
            }

            @Override
            public void setObject(String object) {
                passwordEntered(object);
            }

            @Override
            public void detach() {
                // Empty
            }
        }

        );
        form.add(passwordField);
    }

    protected abstract void passwordEntered(String aPassword);
}
