/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.safe.wicket;

import org.apache.wicket.model.IModel;
import org.wamblee.safe.model.Entry;

public class FieldModel implements IModel<String> {

    private IModel<Entry> entry; 
    private String field; 
    
    public FieldModel(IModel<Entry> aEntry, String aField) { 
        entry = aEntry; 
        field = aField; 
    }
    
    @Override
    public void detach() {
        entry.detach();
    }
    
    @Override
    public String getObject() {
        return entry.getObject().getField(field);
    }
    
    @Override
    public void setObject(String aObject) {
        entry.getObject().setField(field, aObject);   
    }
}
