/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.safe.wicket;

import javax.inject.Inject;

import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.panel.Panel;
import org.wamblee.safe.model.Entry;
import org.wamblee.safe.model.Storage;

/**
 * Homepage
 */
public class HomePage extends BasePage {

    private static final long serialVersionUID = 1L;

    @Inject
    private Storage storage;

    private Panel viewEntries;

    /**
     * Constructor that is invoked when page is invoked without a session.
     *
     * @param parameters Page parameters
     */
    public HomePage(final PageParameters parameters) {
        super();
        EnterEncryptionPasswordPanel passwordPanel = new EnterEncryptionPasswordPanel("password") {
            @Override
            protected void passwordEntered(String aPassword) {
                if (aPassword != null && aPassword.length() > 0) {

                    EncryptionPasswordAccess.setEncryptionPassword(getSession(), aPassword);

                    // validate all entries
                    int nEntries = 0;
                    int nErrors = 0;
                    for (Entry entry : storage.findEntries(0, 1000000)) {
                        nEntries++;
                        if (!entry.isDecryptedOk()) {
                            nErrors++;
                        }
                    }
                    if (nErrors > 0) {
                        getSession().warn("A total of " + nErrors + " entries out of " + nEntries +
                                " could not be decrypted");
                    }
                } else {
                    getSession().warn("You must enter a password");
                }
            }
        };
        add(passwordPanel);
        viewEntries = new ViewEntriesPanel("entries") {
            @Override
            public boolean isVisible() {
                return EncryptionPasswordAccess.isPasswordSet(getSession());
            }
        };
        add(viewEntries);
        getSession();
    }
}
