/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.safe.wicket;

import javax.inject.Inject;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.wamblee.safe.model.Entry;
import org.wamblee.wicket.behavior.OnClickConfirmationBehavior;

public abstract class ViewEntryForm extends Form {

    private static final String[] FIELDS = { "username", "password",
        "description" };
    
    @Inject
    private DetachableEntityFactory factory;

    public ViewEntryForm(String aId, final IModel<Entry> aEntry) { 
        super(aId);
        setDefaultModel(aEntry);
        
        add(new Label("name", new PropertyModel(aEntry, "name")));
        add(new Label("username", new FieldModel(aEntry, "username")));
        add(new Label("password", new FieldModel(aEntry, "password")));
        add(new MultiLineLabel("description", new FieldModel(aEntry, "description")));
        
        Button edit = new Button("edit") {
            @Override
            public void onSubmit() {
                ViewEntryForm.this.editPressed((Entry)ViewEntryForm.this.getDefaultModelObject());
            }
        };
        edit.setDefaultFormProcessing(false);
        add(edit);
        
        Button delete = new Button("delete") {
            @Override
            public void onSubmit() {
                ViewEntryForm.this.deletePressed((Entry)ViewEntryForm.this.getDefaultModelObject());
            }
        };
        delete.setDefaultFormProcessing(false);
        delete.add(new OnClickConfirmationBehavior("Are you sure?"));
        add(delete);
        
        Button back = new Button("back") {
            @Override
            public void onSubmit() {
                ViewEntryForm.this.backPressed();
            }
        };
        back.setDefaultFormProcessing(false);
        add(back);
        
        
    }

    @Override
    protected void onSubmit() {
        // Empty. Ignored default action.
    }
   
    protected abstract void editPressed(Entry aEntry);
    
    protected abstract void deletePressed(Entry aEntry);

    protected abstract void backPressed();

}
