/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.safe.model;

import java.io.Serializable;
import javax.inject.Inject;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.wamblee.inject.InjectorBuilder;
import org.wamblee.safe.model.FieldEncryptor;

@Entity
@Table(name="SAFE_FIELD")
public class Field
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false, length=30000)
    private String value;
    @Inject
    private transient FieldEncryptor fieldEncryptor;

    protected Field() {
    }

    public Field(String aName) {
        this.name = aName;
        this.value = null;
    }

    public Field(String aName, String aValue, FieldEncryptor aEncryptor) {
        this.name = aName;
        this.fieldEncryptor = aEncryptor;
        this.value = this.fieldEncryptor.encrypt(aValue);
    }

    public Field(String aName, String aValue) {
        this.name = aName;
        this.inject();
        this.value = this.fieldEncryptor.encrypt(aValue);
    }

    public void inject() {
        if (this.fieldEncryptor == null) {
            InjectorBuilder.getInjector().inject((Object)this);
        }
    }

    public void set(Field aField) {
        this.name = aField.name;
        this.value = aField.value;
        this.fieldEncryptor = aField.fieldEncryptor;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        this.inject();
        return this.fieldEncryptor.decrypt(this.value);
    }

    public void setValue(String aValue) {
        this.inject();
        this.value = this.fieldEncryptor.encrypt(aValue);
    }

    public boolean equals(Object aObj) {
        if (aObj == null) {
            return false;
        }
        if (!(aObj instanceof Field)) {
            return false;
        }
        Field field = (Field)aObj;
        return this.name.equals(field.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

