/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.safe.security;

import java.io.Serializable;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.wamblee.safe.model.FieldEncryptor;

public class SafeFieldEncryptor
implements FieldEncryptor,
Serializable {
    private static final byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] password = new byte[16];
    private int maxLength;

    public SafeFieldEncryptor(String aPassword, int aMaxLength) {
        int i = 0;
        for (byte b : aPassword.getBytes()) {
            if (i >= 32) continue;
            this.password[i++] = b;
        }
        for (int j = i; j < this.password.length; ++j) {
            this.password[j] = (byte)(this.password[j - i] - 5);
        }
        this.maxLength = aMaxLength;
    }

    public String encrypt(String aValue) {
        String res;
        try {
            Cipher cipher = this.getCipher();
            SecretKeySpec skeyspec = new SecretKeySpec(this.password, "AES");
            cipher.init(1, (Key)skeyspec, new IvParameterSpec(IV));
            byte[] encrypted = cipher.doFinal(aValue.getBytes());
            res = Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (res.length() > this.maxLength) {
            throw new FieldEncryptor.ValueTooLargeException(aValue);
        }
        return res;
    }

    private Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("AES/CBC/PKCS5Padding");
    }

    public String decrypt(String aValue) {
        String res;
        if (aValue == null || aValue.length() == 0) {
            return "";
        }
        try {
            byte[] valueBytes = Base64.getDecoder().decode(aValue);
            Cipher cipher = this.getCipher();
            SecretKeySpec skeyspec = new SecretKeySpec(this.password, "AES");
            cipher.init(2, (Key)skeyspec, new IvParameterSpec(IV));
            byte[] decrypted = cipher.doFinal(valueBytes);
            res = new String(decrypted);
        }
        catch (Exception e) {
            return "___<CANNOT DECRYPT VALUE>___";
        }
        return res;
    }
}

