/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.safe.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.wamblee.safe.model.Entry;
import org.wamblee.safe.model.Field;
import org.wamblee.safe.xml.XMLMapper;
import org.wamblee.xml.DomUtils;

@ApplicationScoped
public class XMLMapperImpl
implements XMLMapper {
    public void encode(OutputStream aOs, List<Entry> aEntries) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("entries");
        try {
            for (Entry entry : aEntries) {
                Element entryElem = root.addElement("entry");
                Element nameElem = entryElem.addElement("name");
                nameElem.setText(entry.getName());
                for (Field field : entry.getFields()) {
                    Element fieldElem = entryElem.addElement("field");
                    fieldElem.setText(field.getValue());
                    fieldElem.addAttribute("name", field.getName());
                }
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setTrimText(false);
            XMLWriter writer = new XMLWriter(aOs, format);
            writer.write(doc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                aOs.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public List<Entry> parse(InputStream aIs) {
        try {
            ArrayList<Entry> result = new ArrayList<Entry>();
            org.w3c.dom.Document domDoc = DomUtils.read((InputStream)aIs);
            Document doc = new DOMReader().read(domDoc);
            Element root = doc.getRootElement();
            for (Element entryElem : root.elements("entry")) {
                String name = entryElem.elementText("name");
                Entry entry = new Entry(name);
                for (Element fieldElem : entryElem.elements("field")) {
                    String fieldName = fieldElem.attributeValue("name");
                    String fieldValue = fieldElem.getText();
                    entry.getFields().add(new Field(fieldName, fieldValue));
                }
                result.add(entry);
            }
            ArrayList<Entry> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Count not parse xml document", e);
        }
        finally {
            try {
                aIs.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

