/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.safe.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;

@Entity
@Table(name = "SAFE_ACCOUNT")
public class Account implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private long id; 
    
    private String name; 
    
    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true, targetEntity = Entry.class)
    @JoinTable(name = "SAFE_ACCOUNT_ENTRY", joinColumns = { @JoinColumn(name = "ACCOUNT_ID") }, 
        inverseJoinColumns = { @JoinColumn(name = "ENTRY_ID") })
    @OrderColumn(name = "ENTRY_INDEX")
    private List<Entry> entries; 
    
    protected Account() { 
        entries = new ArrayList<Entry>();
    }
    
    public Account(String aName) { 
        name = aName; 
        entries = new ArrayList<Entry>();
    }
    
    public Account(String aName, List<Entry> aEntries) { 
        name = aName; 
        entries = aEntries;
    }
    
    public List<Entry> getEntries() {
        return entries;
    }

}
