/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.safe.wicket;

import java.util.Iterator;
import javax.inject.Inject;

import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.wamblee.inject.Injectable;
import org.wamblee.safe.model.Entry;
import org.wamblee.safe.model.Storage;
import org.wamblee.wicket.model.DetachableEntity;

public class EntriesDataProvider extends Injectable implements IDataProvider<Entry> {

    @Inject
    private transient Storage storage;

    public EntriesDataProvider() {
        // Empty.
    }

    @Override
    public Iterator<? extends Entry> iterator(int aFirst, int aCount) {
        return storage.findEntries(aFirst, aCount).iterator();
    }

    @Override
    public int size() {
        return storage.countEntries();
    }

    public IModel<Entry> model(Entry aObject) {
        return new DetachableEntity<Entry>(storage.createDetachable(aObject));
    }

    @Override
    public void detach() {
        // Empty.
    }
}
