/*
 * Copyright 2005-2011 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.safe.wicket;

import javax.enterprise.inject.Produces;

import org.apache.wicket.Session;
import org.wamblee.safe.model.FieldEncryptor;
import org.wamblee.safe.security.SafeFieldEncryptor;

/**
 * Created with IntelliJ IDEA.
 * User: erik
 * Date: 1/3/18
 * Time: 3:07 PM
 * To change this template use File | Settings | File Templates.
 */
public class SafeFieldEncryptorProvider {

    @Produces
    public FieldEncryptor create() {
        return new SafeFieldEncryptor(EncryptionPasswordAccess.getEncryptionPassword(Session.get()), 30000);
    }
}
