/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.gps.geometry;

import java.io.Serializable;


/**
 * Represents a point in some coordinate system. 
 *
 * @author Erik Brakkee
 */
public class Point implements Serializable {
    
    private Coordinates _coordinates;
    private CoordinateSystem _system; 
    
    /**
     * Constructs the point. 
     * @param aCoordinates Coordinates of the point in its coordinate system. 
     * @param aSystem Coordinate system. 
     */
    public Point(Coordinates aCoordinates, CoordinateSystem aSystem) { 
        _coordinates = aCoordinates; 
        _system = aSystem; 
    }
    
    /**
     * Gets the coordinates in the point's coordinate system.  
     * @return Coordinates.
     */
    public Coordinates getCoordinates() {
        return _coordinates; 
    }
    
    public Coordinates getReferenceCoordinates() { 
        return _system.toReferenceSystem(_coordinates);
    }
    
    /**
     * Gets the coordinate system. 
     * @return Coordinate system. 
     */
    public CoordinateSystem getCoordinateSystem() { 
        return _system; 
    }
   

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return getCoordinates().toString();
    }
}
