/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wamblee.gps.geometry;


/**
 * Reference coordinate system which is the basis for defining metrics.
 * This is a Cartesian coordinate system.  
 *
 * @author Erik Brakkee
 */
public class ReferenceCoordinateSystem implements CoordinateSystem {

    /**
     * Constructs the coordinate system. 
     *
     */
    public ReferenceCoordinateSystem() {
        // Empty
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.gpx.CoordinateSystem#toReferenceSystem(org.wamblee.gpx.Coordinates)
     */
    public Coordinates toReferenceSystem(Coordinates aCoordinates) {
        return aCoordinates;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.gpx.CoordinateSystem#distance(org.wamblee.gpx.Coordinates,
     *      org.wamblee.gpx.Coordinates)
     */
    private static double distance(Coordinates aC1, Coordinates aC2) {
        return Math.sqrt(square(aC1.getX1() - aC2.getX1())
                + square(aC1.getX2() - aC2.getX2())
                + square(aC1.getX3() - aC2.getX3()));
    }

    private static double square(double x) {
        return x * x;
    }
    
    /**
     * Computes the distance between two points in arbitrary coordinate systems. 
     * @param aP1 First point. 
     * @param aP2 Second point. 
     * @return Distance. 
     */
    public static double distance(Point aP1, Point aP2) { 
        return distance( aP1.getCoordinateSystem().toReferenceSystem(aP1.getCoordinates()), 
                         aP2.getCoordinateSystem().toReferenceSystem(aP2.getCoordinates()));
    }

}
