package org.wamblee.gps.track;

import java.io.Serializable;
import java.util.List;

import org.wamblee.gps.geometry.Point;

/**
 * Filtered track provides a filtered view on a track. 
 * Changes in the filter are also represented by the filtered track. 
 */
public class FilteredTrack implements Track, Serializable {
    
    private TrackFilter _filter; 
    private Track _originalTrack;
    private Track _filteredTrack; 
    private int _lastVersion; 
    
    public FilteredTrack(TrackFilter aFilter, Track aTrack) { 
        _filter = aFilter; 
        _originalTrack = aTrack;
        _filteredTrack = _filter.filter(_originalTrack);
        _lastVersion = aFilter.version();
    }
    
    private Track getTrack() { 
        if ( _lastVersion != _filter.version()) { 
            _filteredTrack = _filter.filter(_originalTrack);
            _lastVersion = _filter.version();
        }
        return _filteredTrack;
    }
    
    @Override
    public List<TrackSegment> getSegments() {
        return getTrack().getSegments();
    }

    @Override
    public String getDescription() {
        return getTrack().getDescription();
    }

    @Override
    public double getMaxCoordinate(int aI) {
        return getTrack().getMaxCoordinate(aI);
    }

    @Override
    public double getMinCoordinate(int aI) {
        return getTrack().getMinCoordinate(aI);
    }

    @Override
    public Point getPoint(int aIndex) {
        return getTrack().getPoint(aIndex);
    }

    @Override
    public int size() {
        return getTrack().size();
    }

}
