package org.wamblee.gps.track;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.wamblee.gps.geometry.Point;

public class TrackImpl implements Track, Serializable {

    private String _description; 
    private List<TrackSegment> _segments; 
    
    public TrackImpl(String aDescription) { 
        _description = aDescription;
        _segments = new ArrayList<TrackSegment>();
    }
    
    public void addSegment(TrackSegment aSegment) { 
        _segments.add(aSegment);
    }
    
    @Override
    public String getDescription() {
        return _description;
    }
    
    @Override
    public Point getPoint(int aIndex) {
        int localIndex = aIndex; 
        Iterator<TrackSegment> i = _segments.iterator(); 
        while (i.hasNext()) { 
            TrackSegment segment = i.next();
            if ( localIndex < segment.size() ) { 
                return segment.getPoint(localIndex);
            }
            localIndex -= segment.size();
        }
        throw new IndexOutOfBoundsException("" + aIndex);  
    }
    
    @Override
    public double getMinCoordinate(int i) {
        if ( size() == 0 ) { 
            throw new IllegalArgumentException("empty track");
        }
        double result = Double.MAX_VALUE;
        for (TrackSegment segment: _segments) { 
            if ( segment.size() > 0 ) { 
                result = Math.min(result, segment.getMinCoordinate(i));
            }
        }
        return result;
    }
    
    @Override
    public double getMaxCoordinate(int i) {
        if ( size() == 0 ) { 
            throw new IllegalArgumentException("empty track");
        }
        double result = Double.MIN_VALUE;
        for (TrackSegment segment: _segments) { 
            if ( segment.size() > 0 ) { 
                result = Math.max(result, segment.getMaxCoordinate(i));
            }
        }
        return result;
    }
    
    @Override
    public List<TrackSegment> getSegments() {
        return _segments; 
    }
    
    @Override
    public int size() {
        int result = 0; 
        for (TrackSegment segment: _segments) { 
            result += segment.size();
        }
        return result; 
    }
}
