/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.gps.track;

import org.wamblee.gps.geometry.Coordinates;
import org.wamblee.gps.geometry.Point;
import org.wamblee.gps.geometry.Wgs84CoordinateSystem;


/**
 * A point from a GPS track. 
 * 
 * TODO should be extended with additional information (e.g. date/time if available).
 *
 * @author Erik Brakkee
 */
public class TrackPoint extends Point {

    /**
     * Constructs the point. 
     * @param aLatitude Latitude in degrees.  
     * @param aLongitude Longitude in degrees.
     * @param aElevation Elevation in metres.
     */
    public TrackPoint(double aLatitude, double aLongitude, double aElevation) {
        super(new Coordinates(aLatitude, aLongitude, aElevation), new Wgs84CoordinateSystem());
    }
}
