/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gpx;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.wamblee.gps.track.Track;
import org.wamblee.gps.track.TrackSegment;
import org.wamblee.gpx.GpxParser;
import org.wamblee.io.ClassPathResource;
import org.wamblee.xml.XMLException;

public class GpxParserTest
extends TestCase {
    public void testNoJoy() throws IOException, XMLException {
        GpxParser parser = new GpxParser();
        Track track = parser.parse("nojoy.gpx", new ClassPathResource("nojoy.gpx").getInputStream());
        GpxParserTest.assertEquals((int)468, (int)track.size());
        List segments = track.getSegments();
        GpxParserTest.assertEquals((int)1, (int)segments.size());
        GpxParserTest.assertEquals((String)"ACTIVE LOG", (String)((TrackSegment)segments.get(0)).getDescription());
    }

    public void testParseRoute() throws Exception {
        GpxParser parser = new GpxParser();
        Track track = parser.parse("mh2d.route.gpx", new ClassPathResource("mh2d.route.gpx").getInputStream());
        GpxParserTest.assertEquals((int)250, (int)track.size());
        List segments = track.getSegments();
        GpxParserTest.assertEquals((int)1, (int)segments.size());
        GpxParserTest.assertEquals((String)"Generated from track MTB Zaterdag 70 Km", (String)((TrackSegment)segments.get(0)).getDescription());
    }

    public void testParseTrackWithMultipleSegments() throws Exception {
        GpxParser parser = new GpxParser();
        String name = "bbc2009.gpx";
        Track track = parser.parse(name, new ClassPathResource(name).getInputStream());
        GpxParserTest.assertEquals((int)10870, (int)track.size());
        List segments = track.getSegments();
        GpxParserTest.assertEquals((int)3, (int)segments.size());
        GpxParserTest.assertEquals((String)"bbc2009 100", (String)((TrackSegment)segments.get(0)).getDescription());
        GpxParserTest.assertEquals((String)"bbc2009 55", (String)((TrackSegment)segments.get(1)).getDescription());
        GpxParserTest.assertEquals((String)"bbc2009 75", (String)((TrackSegment)segments.get(2)).getDescription());
    }
}

