/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gps.geometry;

import java.io.Serializable;

public class Coordinates
implements Serializable {
    private double _x1;
    private double _x2;
    private double _x3;

    public Coordinates(double aX1, double aX2, double aX3) {
        this._x1 = aX1;
        this._x2 = aX2;
        this._x3 = aX3;
    }

    public double getX1() {
        return this._x1;
    }

    public double getX2() {
        return this._x2;
    }

    public double getX3() {
        return this._x3;
    }

    public double getX(int i) {
        switch (i) {
            case 1: {
                return this._x1;
            }
            case 2: {
                return this._x2;
            }
            case 3: {
                return this._x3;
            }
        }
        throw new IllegalArgumentException("coordinate out of range " + i);
    }

    public String toString() {
        return "(" + this.getX1() + ", " + this.getX2() + ", " + this.getX3() + ")";
    }

    public Coordinates add(Coordinates aC) {
        return new Coordinates(this._x1 + aC._x1, this._x2 + aC._x2, this._x3 + aC._x3);
    }

    public Coordinates subtract(Coordinates aC) {
        return new Coordinates(this._x1 - aC._x1, this._x2 - aC._x2, this._x3 - aC._x3);
    }

    public double innerProduct(Coordinates aC) {
        return this._x1 * aC._x1 + this._x2 * aC._x2 + this._x3 * aC._x3;
    }

    public Coordinates outerProduct(Coordinates aC) {
        return new Coordinates(this._x2 * aC._x3 - this._x3 * aC._x2, -this._x1 * aC._x3 + this._x3 * aC._x1, this._x1 * aC._x2 - this._x2 * aC._x1);
    }

    public double norm() {
        return Math.sqrt(this.innerProduct(this));
    }

    public Coordinates scale(double aMultiplier) {
        return new Coordinates(this._x1 * aMultiplier, this._x2 * aMultiplier, this._x3 * aMultiplier);
    }

    public Coordinates normalize() {
        return this.scale(1.0 / this.norm());
    }
}

