/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gps.geometry;

import org.wamblee.general.Pair;
import org.wamblee.gps.geometry.Coordinates;
import org.wamblee.gps.geometry.Point;

public class Plane {
    private static final double EPS = 1.0E-4;
    private Coordinates _point;
    private Coordinates _normal;
    private Coordinates _north;
    private Coordinates _east;

    public Plane(Point aPoint, Point aNormal) {
        this._point = aPoint.getReferenceCoordinates();
        this._normal = aNormal.getReferenceCoordinates().normalize();
        Coordinates north = new Coordinates(0.0, 0.0, 1.0);
        this._north = north.subtract(this._normal.scale(north.innerProduct(this._normal))).normalize();
        this._east = this._north.outerProduct(this._normal);
        if (this._normal.innerProduct(this._north) > 1.0E-4) {
            throw new IllegalArgumentException("North access is not within the plane");
        }
    }

    private Coordinates project(Point aPoint) {
        Coordinates ref = aPoint.getReferenceCoordinates();
        double lambda = this._normal.innerProduct(this._point.subtract(ref));
        return ref.add(this._normal.scale(lambda));
    }

    public Pair<Double, Double> normalizedProjection(Point aPoint) {
        Coordinates projection = this.project(aPoint);
        Coordinates delta = projection.subtract(this._point);
        double x1 = delta.innerProduct(this._north);
        double x2 = delta.innerProduct(this._east);
        return new Pair((Object)x1, (Object)x2);
    }
}

