/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gps.geometry;

import org.wamblee.gps.geometry.CoordinateSystem;
import org.wamblee.gps.geometry.Coordinates;

public class SphericalCoordinateSystem
implements CoordinateSystem {
    private static final double EARTH_RADIUS = 6371000.0;

    @Override
    public Coordinates toReferenceSystem(Coordinates aCoordinates) {
        double latrad = this.radians(aCoordinates.getX1());
        double lonrad = this.radians(aCoordinates.getX2());
        double coslat = Math.cos(latrad);
        double sinlat = Math.sin(latrad);
        double coslon = Math.cos(lonrad);
        double sinlon = Math.sin(lonrad);
        double trueElevation = 6371000.0 + aCoordinates.getX3();
        return new Coordinates(trueElevation * coslat * coslon, trueElevation * coslat * sinlon, trueElevation * sinlat);
    }

    private double radians(double aDegrees) {
        return aDegrees / 180.0 * Math.PI;
    }
}

