/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gps.geometry;

import org.wamblee.gps.geometry.CoordinateSystem;
import org.wamblee.gps.geometry.Coordinates;

public class Wgs84CoordinateSystem
implements CoordinateSystem {
    private static final double A = 6378137.0;
    private static final double B = 6356752.314;

    @Override
    public Coordinates toReferenceSystem(Coordinates aCoordinates) {
        double latrad = this.radians(aCoordinates.getX1());
        double lonrad = this.radians(aCoordinates.getX2());
        double coslat = Math.cos(latrad);
        double sinlat = Math.sin(latrad);
        double coslon = Math.cos(lonrad);
        double sinlon = Math.sin(lonrad);
        double r = 4.054423713375902E13 / Math.sqrt(4.040829998154436E13 * coslat * coslat + 4.0680631590769E13 * sinlat * sinlat) + aCoordinates.getX3();
        return new Coordinates(r * coslat * coslon, r * coslat * sinlon, r * sinlat);
    }

    private double radians(double aDegrees) {
        return aDegrees / 180.0 * Math.PI;
    }
}

