/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gps.track;

import java.io.Serializable;
import java.util.List;
import org.wamblee.gps.geometry.Point;
import org.wamblee.gps.track.Track;
import org.wamblee.gps.track.TrackFilter;
import org.wamblee.gps.track.TrackSegment;

public class FilteredTrack
implements Track,
Serializable {
    private TrackFilter _filter;
    private Track _originalTrack;
    private Track _filteredTrack;
    private int _lastVersion;

    public FilteredTrack(TrackFilter aFilter, Track aTrack) {
        this._filter = aFilter;
        this._originalTrack = aTrack;
        this._filteredTrack = this._filter.filter(this._originalTrack);
        this._lastVersion = aFilter.version();
    }

    private Track getTrack() {
        if (this._lastVersion != this._filter.version()) {
            this._filteredTrack = this._filter.filter(this._originalTrack);
            this._lastVersion = this._filter.version();
        }
        return this._filteredTrack;
    }

    @Override
    public List<TrackSegment> getSegments() {
        return this.getTrack().getSegments();
    }

    @Override
    public String getDescription() {
        return this.getTrack().getDescription();
    }

    @Override
    public double getMaxCoordinate(int aI) {
        return this.getTrack().getMaxCoordinate(aI);
    }

    @Override
    public double getMinCoordinate(int aI) {
        return this.getTrack().getMinCoordinate(aI);
    }

    @Override
    public Point getPoint(int aIndex) {
        return this.getTrack().getPoint(aIndex);
    }

    @Override
    public int size() {
        return this.getTrack().size();
    }
}

