/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gps.track;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wamblee.gps.geometry.Point;
import org.wamblee.gps.track.Track;
import org.wamblee.gps.track.TrackSegment;

public class TrackImpl
implements Track,
Serializable {
    private String _description;
    private List<TrackSegment> _segments;

    public TrackImpl(String aDescription) {
        this._description = aDescription;
        this._segments = new ArrayList<TrackSegment>();
    }

    public void addSegment(TrackSegment aSegment) {
        this._segments.add(aSegment);
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public Point getPoint(int aIndex) {
        int localIndex = aIndex;
        for (TrackSegment segment : this._segments) {
            if (localIndex < segment.size()) {
                return segment.getPoint(localIndex);
            }
            localIndex -= segment.size();
        }
        throw new IndexOutOfBoundsException("" + aIndex);
    }

    @Override
    public double getMinCoordinate(int i) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("empty track");
        }
        double result = Double.MAX_VALUE;
        for (TrackSegment segment : this._segments) {
            if (segment.size() <= 0) continue;
            result = Math.min(result, segment.getMinCoordinate(i));
        }
        return result;
    }

    @Override
    public double getMaxCoordinate(int i) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("empty track");
        }
        double result = Double.MIN_VALUE;
        for (TrackSegment segment : this._segments) {
            if (segment.size() <= 0) continue;
            result = Math.max(result, segment.getMaxCoordinate(i));
        }
        return result;
    }

    @Override
    public List<TrackSegment> getSegments() {
        return this._segments;
    }

    @Override
    public int size() {
        int result = 0;
        for (TrackSegment segment : this._segments) {
            result += segment.size();
        }
        return result;
    }
}

