/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gps.track;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wamblee.gps.geometry.Point;
import org.wamblee.gps.track.TrackPoint;
import org.wamblee.gps.track.TrackSegment;

public class TrackSegmentImpl
implements Serializable,
TrackSegment {
    private String _description;
    private List<TrackPoint> _points;

    public TrackSegmentImpl(String aDescription) {
        this._description = aDescription;
        this._points = new ArrayList<TrackPoint>();
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void addPoint(TrackPoint aPoint) {
        this._points.add(aPoint);
    }

    @Override
    public int size() {
        return this._points.size();
    }

    @Override
    public double getMinCoordinate(int i) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("empty track");
        }
        double min = this.getPoint(0).getCoordinates().getX(i);
        for (int j = 1; j < this.size(); ++j) {
            min = Math.min(min, this.getPoint(j).getCoordinates().getX(i));
        }
        return min;
    }

    @Override
    public double getMaxCoordinate(int i) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("empty track");
        }
        double max = this.getPoint(0).getCoordinates().getX(i);
        for (int j = 1; j < this.size(); ++j) {
            max = Math.max(max, this.getPoint(j).getCoordinates().getX(i));
        }
        return max;
    }

    @Override
    public Point getPoint(int aIndex) {
        return this._points.get(aIndex);
    }
}

