/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gpx;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.wamblee.gps.track.Track;
import org.wamblee.gps.track.TrackImpl;
import org.wamblee.gps.track.TrackPoint;
import org.wamblee.gps.track.TrackSegmentImpl;
import org.wamblee.xml.DomUtils;
import org.wamblee.xml.XMLException;

public class GpxParser {
    private static final String SCHEMA_RESOURCE = "gpx.xsd";

    public Track parse(String aDescription, InputStream aIs) throws XMLException {
        Document doc = DomUtils.convert((org.w3c.dom.Document)DomUtils.read((InputStream)aIs));
        return this.parse(aDescription, doc);
    }

    public Track parse(String aDescription, Document doc) {
        List routes;
        TrackImpl result = new TrackImpl(aDescription);
        List tracks = doc.getRootElement().elements("trk");
        if (tracks != null) {
            for (Element track : tracks) {
                String trackName = track.elementText("name");
                TrackSegmentImpl trackSegment = new TrackSegmentImpl(trackName);
                result.addSegment(trackSegment);
                List segments = track.elements("trkseg");
                if (segments == null) continue;
                for (Element segment : segments) {
                    this.parseTrackPoints(trackSegment, segment.elementIterator("trkpt"));
                }
            }
        }
        if ((routes = doc.getRootElement().elements("rte")) != null) {
            for (Element route : routes) {
                String routeName = route.elementText("desc");
                TrackSegmentImpl trackSegment = new TrackSegmentImpl(routeName);
                result.addSegment(trackSegment);
                this.parseTrackPoints(trackSegment, route.elementIterator("rtept"));
            }
        }
        return result;
    }

    private void parseTrackPoints(TrackSegmentImpl aTrack, Iterator<Element> aPoints) {
        while (aPoints.hasNext()) {
            Element point = aPoints.next();
            aTrack.addPoint(this.parseTrackPoint(point));
        }
    }

    private TrackPoint parseTrackPoint(Element trkpt) {
        double latitude = new Double(trkpt.attributeValue("lat"));
        double longitude = new Double(trkpt.attributeValue("lon"));
        Element ele = trkpt.element("ele");
        double elevation = 0.0;
        if (ele != null) {
            elevation = new Double(ele.getText());
        }
        return new TrackPoint(latitude, longitude, elevation);
    }
}

