/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gpx;

import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.wamblee.general.Pair;
import org.wamblee.gps.geometry.Plane;
import org.wamblee.gps.geometry.Point;
import org.wamblee.gps.geometry.ReferenceCoordinateSystem;
import org.wamblee.gps.track.Track;
import org.wamblee.gps.track.TrackSegment;
import org.wamblee.gpx.GpxParser;
import org.wamblee.gpx.TrackStatistics;
import org.wamblee.gpx.ZoomableBackgroundXYPlot;
import org.wamblee.utils.JpegUtils;

public class GpxPlotter {
    public static void main(String[] aArgs) throws Exception {
        File file = new File(aArgs[0]);
        GpxParser parser = new GpxParser();
        Track track = parser.parse(file.getName(), new FileInputStream(file));
        TrackStatistics profile = new TrackStatistics(track);
        profile.writeHeightProfilePng(new FileOutputStream("x.png"), 600, 300);
        List<Pair<Double, Double>> elevationProfile = GpxPlotter.computeElevationProfile(track);
        GpxPlotter.printTrack(elevationProfile);
        GpxPlotter.computeTotalClimb(elevationProfile);
        GpxPlotter.plotElevationProfile(elevationProfile);
        List<Pair<Double, Double>> trackXy = GpxPlotter.computeTrackXY(track);
        List<Pair<Double, Double>> trackLatLon = GpxPlotter.computeTrackLatLon(track);
        GpxPlotter.plotTrack(trackLatLon);
    }

    private static List<Pair<Double, Double>> computeElevationProfile(TrackSegment aTrack) {
        ArrayList<Pair<Double, Double>> results = new ArrayList<Pair<Double, Double>>();
        double distance = 0.0;
        for (int i = 0; i < aTrack.size(); ++i) {
            Point point = aTrack.getPoint(i);
            results.add((Pair<Double, Double>)new Pair((Object)distance, (Object)point.getCoordinates().getX3()));
            if (i + 1 >= aTrack.size()) continue;
            Point nextPoint = aTrack.getPoint(i + 1);
            distance += ReferenceCoordinateSystem.distance(point, nextPoint);
        }
        return results;
    }

    private static List<Pair<Double, Double>> computeTrackXY(TrackSegment aTrack) {
        Point reference = aTrack.getPoint(0);
        Plane plane = new Plane(reference, reference);
        ArrayList<Pair<Double, Double>> results = new ArrayList<Pair<Double, Double>>();
        for (int i = 0; i < aTrack.size(); ++i) {
            Point point = aTrack.getPoint(i);
            Pair<Double, Double> projection = plane.normalizedProjection(point);
            results.add(projection);
            System.out.println(point);
        }
        return results;
    }

    private static List<Pair<Double, Double>> computeTrackLatLon(TrackSegment aTrack) {
        ArrayList<Pair<Double, Double>> results = new ArrayList<Pair<Double, Double>>();
        for (int i = 0; i < aTrack.size(); ++i) {
            Point point = aTrack.getPoint(i);
            results.add((Pair<Double, Double>)new Pair((Object)point.getCoordinates().getX1(), (Object)point.getCoordinates().getX2()));
        }
        return results;
    }

    private static void printTrack(List<Pair<Double, Double>> aHeightProfile) {
        for (Pair<Double, Double> point : aHeightProfile) {
            System.out.println(point.getFirst() + " " + point.getSecond());
        }
    }

    private static void computeTotalClimb(List<Pair<Double, Double>> aHeightProfile) {
        double result = 0.0;
        double lastHeight = (Double)aHeightProfile.get(0).getSecond();
        for (int i = 1; i < aHeightProfile.size(); ++i) {
            double height = (Double)aHeightProfile.get(i).getSecond();
            if (height > lastHeight) {
                result += height - lastHeight;
            }
            lastHeight = height;
        }
        System.out.println("Total climb: " + result);
    }

    private static void plotElevationProfile(List<Pair<Double, Double>> aHeightProfile) throws IOException {
        XYSeriesCollection dataset = GpxPlotter.createDataset(aHeightProfile, "height");
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Height Profile", (String)"Distance(m)", (String)"Height(m)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ChartUtilities.writeChartAsPNG((OutputStream)new FileOutputStream("height.png"), (JFreeChart)chart, (int)600, (int)300);
        ChartFrame frame = new ChartFrame("test", chart);
        frame.pack();
        frame.setVisible(true);
    }

    private static void plotTrack(List<Pair<Double, Double>> aPoints) throws IOException, InterruptedException {
        XYSeriesCollection dataset = GpxPlotter.createDataset(aPoints, "track");
        JFreeChart chart = GpxPlotter.createLineChart(dataset);
        Pair<Pair<Double, Double>, Pair<Double, Double>> bounds = GpxPlotter.getBounds(aPoints);
        chart.getXYPlot().getDomainAxis().setLowerBound(((Double)((Pair)bounds.getFirst()).getFirst()).doubleValue());
        chart.getXYPlot().getDomainAxis().setUpperBound(((Double)((Pair)bounds.getFirst()).getSecond()).doubleValue());
        chart.getXYPlot().getRangeAxis().setLowerBound(((Double)((Pair)bounds.getSecond()).getFirst()).doubleValue());
        chart.getXYPlot().getRangeAxis().setUpperBound(((Double)((Pair)bounds.getSecond()).getSecond()).doubleValue());
        BufferedImage background = JpegUtils.loadJpegImage(new FileInputStream("/home/erik/vakantie.jpg"));
        chart.getPlot().setBackgroundImage((Image)background);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)chart.getXYPlot().getRenderer();
        renderer.setShapesVisible(true);
        renderer.setShapesFilled(true);
        renderer.setPaint((Paint)Color.BLACK);
        ChartUtilities.writeChartAsPNG((OutputStream)new FileOutputStream("test.png"), (JFreeChart)chart, (int)1280, (int)800);
        ChartFrame frame = new ChartFrame("test", chart);
        frame.pack();
        frame.setVisible(true);
    }

    private static JFreeChart createLineChart(XYSeriesCollection dataset) {
        NumberAxis xAxis = new NumberAxis("S->N");
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis("W->E");
        yAxis.setAutoRangeIncludesZero(false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        ZoomableBackgroundXYPlot plot = new ZoomableBackgroundXYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart chart = new JFreeChart("Track", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        return chart;
    }

    private static XYSeriesCollection createDataset(List<Pair<Double, Double>> aHeightProfile, String aName) {
        XYSeries series = new XYSeries((Comparable)((Object)aName), false);
        for (Pair<Double, Double> point : aHeightProfile) {
            series.add((Number)point.getFirst(), (Number)point.getSecond());
        }
        XYSeriesCollection dataset = new XYSeriesCollection(series);
        return dataset;
    }

    private static Pair<Pair<Double, Double>, Pair<Double, Double>> getBounds(List<Pair<Double, Double>> aList) {
        double miny;
        double minx;
        Pair<Double, Double> first = aList.get(0);
        double maxx = minx = ((Double)first.getFirst()).doubleValue();
        double maxy = miny = ((Double)first.getSecond()).doubleValue();
        for (int i = 0; i < aList.size(); ++i) {
            Pair<Double, Double> value = aList.get(i);
            minx = Math.min(minx, (Double)value.getFirst());
            maxx = Math.max(maxx, (Double)value.getFirst());
            miny = Math.min(miny, (Double)value.getSecond());
            maxy = Math.max(maxy, (Double)value.getSecond());
        }
        if (maxx == minx) {
            maxx += 1.0;
        }
        if (maxy == miny) {
            maxy += 1.0;
        }
        double paddingFactor = 0.3;
        return new Pair((Object)new Pair((Object)(minx - 0.3 * (maxx - minx)), (Object)(maxx + 0.3 * (maxx - minx))), (Object)new Pair((Object)(miny - 0.3 * (maxy - miny)), (Object)(maxy + 0.3 * (maxy - miny))));
    }
}

