/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gpx;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.wamblee.general.Pair;
import org.wamblee.gps.geometry.Point;
import org.wamblee.gps.geometry.ReferenceCoordinateSystem;
import org.wamblee.gps.track.TrackSegment;

public class TrackStatistics
implements Serializable {
    private TrackSegment _track;

    public TrackStatistics(TrackSegment aTrack) {
        this._track = aTrack;
    }

    public void writeHeightProfilePng(OutputStream aStream, int aWidth, int aHeight) throws IOException {
        List<Pair<Double, Double>> data = this.computeElevationProfile();
        XYSeriesCollection dataset = TrackStatistics.createDataset(data, "height");
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Height Profile", (String)"Distance(km)", (String)"Height(m)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        ChartUtilities.writeChartAsPNG((OutputStream)aStream, (JFreeChart)chart, (int)aWidth, (int)aHeight);
    }

    private static XYSeriesCollection createDataset(List<Pair<Double, Double>> aHeightProfile, String aName) {
        XYSeries series = new XYSeries((Comparable)((Object)aName), false);
        for (Pair<Double, Double> point : aHeightProfile) {
            series.add((Double)point.getFirst() / 1000.0, (Number)point.getSecond());
        }
        XYSeriesCollection dataset = new XYSeriesCollection(series);
        return dataset;
    }

    public List<Pair<Double, Double>> computeElevationProfile() {
        ArrayList<Pair<Double, Double>> results = new ArrayList<Pair<Double, Double>>();
        double distance = 0.0;
        for (int i = 0; i < this._track.size(); ++i) {
            Point point = this._track.getPoint(i);
            results.add((Pair<Double, Double>)new Pair((Object)distance, (Object)point.getCoordinates().getX3()));
            if (i + 1 >= this._track.size()) continue;
            Point nextPoint = this._track.getPoint(i + 1);
            distance += ReferenceCoordinateSystem.distance(point, nextPoint);
        }
        return results;
    }

    public double getTotalClimb() {
        List<Pair<Double, Double>> data = this.computeElevationProfile();
        double result = 0.0;
        if (data.size() == 0) {
            return result;
        }
        double lastHeight = (Double)data.get(0).getSecond();
        for (int i = 1; i < data.size(); ++i) {
            double height = (Double)data.get(i).getSecond();
            if (height > lastHeight) {
                result += height - lastHeight;
            }
            lastHeight = height;
        }
        return result;
    }

    public double getDistance() {
        List<Pair<Double, Double>> data = this.computeElevationProfile();
        if (data.size() == 0) {
            return 0.0;
        }
        return (Double)data.get(data.size() - 1).getFirst();
    }
}

