/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.gpx;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class ZoomableBackgroundXYPlot
extends XYPlot {
    private double _x1 = 1.0;
    private double _x2 = -1.0;
    private double _y1 = 1.0;
    private double _y2 = -1.0;

    public ZoomableBackgroundXYPlot(XYDataset aDataset, ValueAxis aDomainAxis, ValueAxis aRangeAxis, XYItemRenderer aRenderer) {
        super(aDataset, aDomainAxis, aRangeAxis, aRenderer);
    }

    protected void drawBackgroundImage(Graphics2D g2, Rectangle2D area) {
        double y1 = this.getDomainAxis().getLowerBound();
        double y2 = this.getDomainAxis().getUpperBound();
        double x1 = this.getRangeAxis().getLowerBound();
        double x2 = this.getRangeAxis().getUpperBound();
        if (this._x2 < this._x1) {
            this._y1 = y1;
            this._y2 = y2;
            this._x1 = x1;
            this._x2 = x2;
        }
        Image background = this.getBackgroundImage();
        int width = background.getWidth(null);
        int height = background.getHeight(null);
        int imageX1 = (int)Math.round(1.0 + (x1 - this._x1) * (double)(width - 1) / (this._x2 - this._x1));
        int imageX2 = (int)Math.round(1.0 + (x2 - this._x1) * (double)(width - 1) / (this._x2 - this._x1));
        int imageY2 = (int)Math.round((double)height + (y1 - this._y1) * (double)(1 - height) / (this._y2 - this._y1));
        int imageY1 = (int)Math.round((double)height + (y2 - this._y1) * (double)(1 - height) / (this._y2 - this._y1));
        g2.drawImage(background, (int)area.getMinX(), (int)area.getMinY(), (int)area.getMaxX(), (int)area.getMaxY(), imageX1, imageY1, imageX2, imageY2, null);
    }
}

