/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.utils;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JpegUtils {
    public static BufferedImage scaleImage(int aMaxWidth, int aMaxHeight, Image aImage) {
        int imageHeight;
        double thumbRatio = (double)aMaxWidth / (double)aMaxHeight;
        int imageWidth = aImage.getWidth(null);
        double imageRatio = (double)imageWidth / (double)(imageHeight = aImage.getHeight(null));
        if (thumbRatio < imageRatio) {
            aMaxHeight = (int)((double)aMaxWidth / imageRatio);
        } else {
            aMaxWidth = (int)((double)aMaxHeight * imageRatio);
        }
        BufferedImage thumbImage = new BufferedImage(aMaxWidth, aMaxHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(aImage, 0, 0, aMaxWidth, aMaxHeight, null);
        return thumbImage;
    }

    public static BufferedImage loadJpegImage(InputStream aInput) throws IOException, InterruptedException {
        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)aInput);
        BufferedImage image = decoder.decodeAsBufferedImage();
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        mediaTracker.waitForID(0);
        return image;
    }

    public static void writeJpegImage(OutputStream aOutput, int aQuality, BufferedImage aThumbImage) throws IOException {
        if (aQuality < 0 || aQuality > 100) {
            throw new IllegalArgumentException("Argument quality must be in range 0.100: " + aQuality);
        }
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)aOutput);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(aThumbImage);
        aQuality = Math.max(0, Math.min(aQuality, 100));
        param.setQuality((float)aQuality / 100.0f, false);
        encoder.setJPEGEncodeParam(param);
        encoder.encode(aThumbImage);
    }
}

