/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.security.authorization;

/**
 * An superclass of all other operations. 
 */
public class AllOperation implements Operation {
    
    private static final String OPERATION = "all";
    
    /**
     * Operation name. 
     */
    private String _name;
    
    /**
     * Constructs an all operation. 
     *
     */
    public AllOperation() { 
        _name = OPERATION; 
    }
    
    /**
     * Constructs the operation, this constructor is the one that must be used
     * by subclasses. 
     * @param aName Name of the operation. This name must be unique among all operations. 
     */
    protected AllOperation(String aName) { 
        _name = aName; 
    }

    /* (non-Javadoc)
     * @see org.wamblee.security.authorization.Operation#getName()
     */
    public String getName() {
        return _name; 
    }

}
