/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.security.authorization;

import org.wamblee.persistence.AbstractPersistent;
import org.wamblee.usermgt.User;

/**
 * Matches any user. 
 *
 * @author Erik Brakkee
 */
public class AnyUserCondition extends AbstractPersistent implements UserCondition {
    
    /**
     * Constructs the condition. 
     *
     */
    public AnyUserCondition() { 
        // Empty. 
    }

    /* (non-Javadoc)
     * @see org.wamblee.security.authorization.UserCondition#matches(org.wamblee.usermgt.User)
     */
    public boolean matches(User aUser) {
        return true; 
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "AnyUserCondition()"; 
    }

}
